package com.example.sefinsa_app;

import static androidx.constraintlayout.helper.widget.MotionEffect.TAG;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothDevice;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.InputType;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.DialogFragment;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PagoController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.PrestamoController;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.databinding.ActivityDashboardBinding;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.rmd.RMDFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChangeListener;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.navigation.NavigationView;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DashboardActivity extends AppCompatActivity implements NetworkChangeReceiver.NetworkChangeListener {
    private AppBarConfiguration mAppBarConfiguration;
    private ActivityDashboardBinding binding;
    private SharedPreferences sesion;
    private String usuario, nombre, telefono;
    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private AvalController avalController;
    private PrestamoController prestamoController;
    private PagoController pagoController;

    private VolleyS vs;
    private RequestQueue requestQueue;
    private int retryCount = 0; // Contador de reintentos
    private static final int MAX_RETRIES = 80; // Máximo de reintentos
    private NavController navController;
    private TextView navHeaderNombreUsuario;
    private TextView navHeaderNombreCompleto;
    NetworkChangeListener networkChangeListener = new NetworkChangeListener();
    Context context;
    private NetworkChangeReceiver networkChangeReceiver;
    private boolean isConnected = true;

    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;
    }

    private void initControllers() {
        rutaController = new RutaController(DashboardActivity.this);
        poblacionController = new PoblacionController(DashboardActivity.this);
        colocadoraController = new ColocadoraController(DashboardActivity.this);
        clienteController = new ClienteController(DashboardActivity.this);
        avalController = new AvalController(DashboardActivity.this);
        prestamoController = new PrestamoController(DashboardActivity.this);
        pagoController = new PagoController(DashboardActivity.this);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Locale.setDefault(Locale.US);

        networkChangeReceiver = new NetworkChangeReceiver(this);
        //pagosHechosController.truncate();
        //pagoController.truncate();
        Locale.setDefault(Locale.US);
        initControllers();

        final Handler handler = new Handler();

        sesion = getSharedPreferences("sesion", Context.MODE_PRIVATE);
        usuario = sesion.getString("usuario", "");
        nombre = sesion.getString("nombre", "");
        telefono = sesion.getString("telefono", "");

        new MaterialAlertDialogBuilder(DashboardActivity.this)
                .setTitle("¿Desea conectarse a la impresora?")
                .setCancelable(false)
                .setPositiveButton("Sí", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        BluetoothUtils.context = getApplicationContext();

                        BluetoothUtils.listPairedDevices(sesion.getString("impresora", "SP-T12 Printer"));
                        IntentFilter filter = new IntentFilter();
                        filter.addAction(BluetoothDevice.ACTION_ACL_CONNECTED);
                        filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECT_REQUESTED);
                        filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECTED);
                        registerReceiver(BluetoothUtils.BTReceiver, filter);
                        BluetoothUtils.broadcastReceiver();
                        BluetoothUtils.initThread();
                    }
                })
                .setNegativeButton("No", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                })
                .show();

        binding = ActivityDashboardBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        setSupportActionBar(binding.appBarDashboard.toolbar);

        DrawerLayout drawer = binding.drawerLayout;
        NavigationView navigationView = binding.navView;

        View headerView = navigationView.getHeaderView(0);
        navHeaderNombreUsuario = headerView.findViewById(R.id.navHeaderNombreUsuario);
        navHeaderNombreCompleto = headerView.findViewById(R.id.navHeaderNombre);
        navHeaderNombreUsuario.setText(usuario + " (" + sesion.getString("nombre_perfil", "") + ")");
        navHeaderNombreCompleto.setText(nombre);

        navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_dashboard);

        if (sesion.getString("nombre_perfil", "").equals("Administrador") || sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {

            mAppBarConfiguration = new AppBarConfiguration.Builder(
                    R.id.nav_avales, R.id.nav_clientes, R.id.nav_prestamos, R.id.nav_historial, R.id.nav_reporte, R.id.nav_reporte_diario, R.id.nav_reporte_general,
                    R.id.nav_reporte_creditos, R.id.nav_folios, R.id.nav_rmd)
                    .setOpenableLayout(drawer)
                    .build();

            NavigationUI.setupActionBarWithNavController(this, navController, mAppBarConfiguration);
            NavigationUI.setupWithNavController(navigationView, navController);

        } else if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                || sesion.getString("nombre_perfil", "").equals("GESTOR")
                || sesion.getString("nombre_perfil", "").equals("JURIDICO")) {

            Menu nav_Menu = navigationView.getMenu();

            nav_Menu.findItem(R.id.nav_reporte).setVisible(false);
            nav_Menu.findItem(R.id.nav_reporte_diario).setVisible(false);
            nav_Menu.findItem(R.id.nav_reporte_creditos).setVisible(false);
            if (sesion.getString("nombre_perfil", "").equals("JURIDICO")) {
                nav_Menu.findItem(R.id.nav_clientes).setVisible(false);
                nav_Menu.findItem(R.id.nav_avales).setVisible(false);
            }

            mAppBarConfiguration = new AppBarConfiguration.Builder(
                    R.id.nav_avales, R.id.nav_clientes, R.id.nav_prestamos, R.id.nav_historial, R.id.nav_reporte,
                    R.id.nav_reporte_diario, R.id.nav_reporte_general,
                    R.id.nav_reporte_creditos, R.id.nav_folios, R.id.nav_rmd)
                    .setOpenableLayout(drawer)
                    .build();
            NavigationUI.setupActionBarWithNavController(this, navController, mAppBarConfiguration);
            NavigationUI.setupWithNavController(navigationView, navController);

            navController.navigate(R.id.nav_prestamos);
        } else if (sesion.getString("nombre_perfil", "").equals("VOCERO")) {

            Menu nav_Menu = navigationView.getMenu();
            nav_Menu.findItem(R.id.nav_reporte).setVisible(false);
            nav_Menu.findItem(R.id.nav_reporte_diario).setVisible(false);
            nav_Menu.findItem(R.id.nav_reporte_creditos).setVisible(false);

            mAppBarConfiguration = new AppBarConfiguration.Builder(
                    R.id.nav_avales, R.id.nav_historial, R.id.nav_clientes, R.id.nav_prestamos, R.id.nav_reporte_general, R.id.nav_folios, R.id.nav_rmd)
                    .setOpenableLayout(drawer)
                    .build();
            NavigationUI.setupActionBarWithNavController(this, navController, mAppBarConfiguration);
            NavigationUI.setupWithNavController(navigationView, navController);

        }

        sincronizarRutas();
        sincronizarPoblaciones();
        sincronizarColocadoras();

        navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener() {
            @Override
            public boolean onNavigationItemSelected(@NonNull MenuItem item) {

                switch (item.getItemId()) {
                    case R.id.nav_avales:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_avales);

                        drawer.closeDrawer(GravityCompat.START);
                        break;

                    case R.id.nav_clientes:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_clientes);

                        drawer.closeDrawer(GravityCompat.START);
                        break;

                    case R.id.nav_prestamos:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_prestamos);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_historial:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_historial);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_reporte:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_reporte);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_reporte_general:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_reporte_general);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_reporte_diario:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_reporte_diario);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_reporte_creditos:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_reporte_creditos);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_folios:

                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_folios);
                        drawer.closeDrawer(GravityCompat.START);

                        break;

                    case R.id.nav_rmd:
                        Navigation.findNavController(DashboardActivity.this, R.id.nav_host_fragment_content_dashboard).navigate(R.id.nav_rmd);
                        drawer.closeDrawer(GravityCompat.START);
                        break;

                    case R.id.nav_impresora:

                        drawer.closeDrawer(GravityCompat.START);

                        String[] opcionesImp = {"Conectar", "Cambiar nombre"};
                        final int[] opcionElegidaImp = {-1};

                        new MaterialAlertDialogBuilder(DashboardActivity.this)
                                .setTitle("Impresora")
                                .setSingleChoiceItems(opcionesImp, -1, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                        opcionElegidaImp[0] = i;
                                    }
                                })
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                        if (opcionElegidaImp[0] == 1) {

                                            AlertDialog.Builder builder = new AlertDialog.Builder(DashboardActivity.this);
                                            builder.setTitle("Nombre de impresora");

                                            final EditText input = new EditText(DashboardActivity.this);
                                            input.setInputType(InputType.TYPE_CLASS_TEXT);
                                            String impresora = sesion.getString("impresora", "SP-T12 Printer");
                                            input.setText(impresora);
                                            builder.setView(input);
                                            builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialog, int which) {

                                                    new MaterialAlertDialogBuilder(DashboardActivity.this)
                                                            .setTitle("AVISO")
                                                            .setCancelable(false)
                                                            .setMessage("Se cerrara la aplicación para aplicar los cambios de la impresora")
                                                            .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                                                                @Override
                                                                public void onClick(DialogInterface dialogInterface, int i) {

                                                                    SharedPreferences.Editor editor = sesion.edit();
                                                                    editor.putString("impresora", input.getText().toString());
                                                                    editor.commit();

                                                                    moveTaskToBack(true);
                                                                    android.os.Process.killProcess(android.os.Process.myPid());
                                                                    System.exit(1);
                                                                }
                                                            })
                                                            .setNegativeButton("CANCELAR", new DialogInterface.OnClickListener() {
                                                                @Override
                                                                public void onClick(DialogInterface dialogInterface, int i) {
                                                                }
                                                            })
                                                            .show();
                                                }
                                            });
                                            builder.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialog, int which) {
                                                    dialog.cancel();
                                                }
                                            });

                                            builder.show();
                                        } else if (opcionElegidaImp[0] == 0) {

                                            BluetoothUtils.context = getApplicationContext();

                                            BluetoothUtils.listPairedDevices(sesion.getString("impresora", "SP-T12 Printer"));
                                            IntentFilter filter = new IntentFilter();
                                            filter.addAction(BluetoothDevice.ACTION_ACL_CONNECTED);
                                            filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECT_REQUESTED);
                                            filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECTED);
                                            registerReceiver(BluetoothUtils.BTReceiver, filter);
                                            BluetoothUtils.broadcastReceiver();
                                            BluetoothUtils.initThread();
                                        }
                                    }
                                })
                                .show();
                        break;

                    case R.id.nav_sincronizar:
                        String[] opciones = {"Clientes y avales", "Préstamos y Pagos", "Rutas", "Poblaciones", "Colocadoras", "Reporte Diario", "Reporte creditos", "Folios", "RMD"};
                        final int[] opcionElegida = {-1};

                        new MaterialAlertDialogBuilder(DashboardActivity.this)
                                .setTitle("Sincronizar")
                                .setSingleChoiceItems(opciones, -1, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                        opcionElegida[0] = i;
                                    }
                                })
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                        if (opcionElegida[0] == 0) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando clientes y avales", Toast.LENGTH_LONG).show();
                                            sincronizarClientesAvales();
                                        } else if (opcionElegida[0] == 1) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando préstamos", Toast.LENGTH_LONG).show();
                                            sincronizarPrestamosPagos();
                                        } else if (opcionElegida[0] == 2) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando rutas", Toast.LENGTH_LONG).show();
                                            sincronizarRutas();
                                        } else if (opcionElegida[0] == 3) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando poblaciones", Toast.LENGTH_LONG).show();
                                            sincronizarPoblaciones();
                                        } else if (opcionElegida[0] == 4) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando colocadoras", Toast.LENGTH_LONG).show();
                                            sincronizarColocadoras();
                                        } else if (opcionElegida[0] == 5) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando Reporte diario", Toast.LENGTH_LONG).show();
                                            sincronizarReporteDiario();
                                        } else if (opcionElegida[0] == 6) {
                                            Toast.makeText(DashboardActivity.this, "Sincronizando Reporte creditos", Toast.LENGTH_LONG).show();
                                            sincronizarReporteCreditos();
                                        } else if (opcionElegida[0] == 7) {
                                            syncFolios();
                                        } else if (opcionElegida[0] == 8) {
                                            dbSync();
                                        }
                                    }
                                })
                                .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                    }
                                })
                                .show();

                        break;

                    case R.id.nav_cerrar_sesion:

                        new MaterialAlertDialogBuilder(DashboardActivity.this)
                                .setTitle("Aviso")
                                .setMessage("¿Desea cerrar sesión?")
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                        // Cancelar los trabajos del WorkManager
                                        WorkManager workManager = WorkManager.getInstance(DashboardActivity.this);
                                        workManager.cancelUniqueWork("UpdateLastExecutionTimeClientesWorker");
                                        workManager.cancelUniqueWork("ClientesWorker");

                                        workManager.cancelUniqueWork("ImmediatePrestamosWorker");
                                        workManager.cancelUniqueWork("PrestamosWorker");

                                        workManager.cancelUniqueWork("ImmediateAvalesWorker");
                                        workManager.cancelUniqueWork("AvalesWorker");

                                        workManager.cancelUniqueWork("UpdateLastExecutionTimePagosWorker");
                                        workManager.cancelUniqueWork("PagosWorker");

                                        //clearCacheAvales();
                                        BluetoothUtils.closeThread();
                                        Intent intent = new Intent(DashboardActivity.this, LoginActivity.class);
                                        startActivity(intent);
                                        finish();
                                    }
                                })
                                .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                    }
                                })
                                .show();
                        break;
                }
                return false;
            }
        });
    }

    @Override
    public void onStart() {
        IntentFilter intentFilter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
        registerReceiver(networkChangeListener, intentFilter);
        super.onStart();
    }

    @Override
    public void onStop() {
        unregisterReceiver(networkChangeListener);
        super.onStop();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        WorkManager workManager = WorkManager.getInstance(DashboardActivity.this);

        workManager.cancelAllWork();

        WorkManager.getInstance(DashboardActivity.this).cancelAllWork();
        DashboardActivity.this.deleteDatabase("workmanager.db");
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        try {
            getMenuInflater().inflate(R.menu.dashboard, menu);
        } catch (Exception e) {
            Log.e("DashboardActivity", "Error inflating menu", e);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        return false;
    }

    @Override
    public boolean onSupportNavigateUp() {
        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_dashboard);
        return NavigationUI.navigateUp(navController, mAppBarConfiguration)
                || super.onSupportNavigateUp();
    }

    public String getCurrentFragment() {
        return getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment_content_dashboard).getClass().getSimpleName();
    }

    public void sincronizarClientesAvales() {
        ClientesWorker.currentPageClientes = 0;
        ClientesWorker.allDataLoadedClientes = true;
        ClientesWorker.isTaskClientesCompleted = false;

        AvalesWorker.currentPageAvales = 0;
        AvalesWorker.allDataLoadedAvales = true;
        AvalesWorker.isTaskAvalesCompleted = false;

        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
            @Override
            public void run() {
                AvalesWorker.enqueueWork(DashboardActivity.this);
                checckBanderaAvales();
            }
        }, 1000);
    }

    private void checckBanderaAvales() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                ClientesWorker.enqueueWork(DashboardActivity.this);
            } else {
                Log.d("PRESTAMOS", "Tarea avales aún no completadas. Reintentando en 500ms...");
                checckBanderaAvales(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }

    public void sincronizarPrestamosPagos() {

        SQLiteDatabase db = new DatabaseHelper(this).getReadableDatabase();

        // Verificar si la tabla prestamos está vacía
        Cursor cursorPrestamos = db.rawQuery("SELECT COUNT(*) FROM prestamos", null);
        if (cursorPrestamos.moveToFirst() && cursorPrestamos.getInt(0) == 0) {
            PrestamosWorker.allDataLoadedPrestamos = false;
        } else {
            PrestamosWorker.allDataLoadedPrestamos = true;
        }
        cursorPrestamos.close();

        // Verificar si la tabla pagos está vacía
        Cursor cursorPagos = db.rawQuery("SELECT COUNT(*) FROM pagos", null);
        if (cursorPagos.moveToFirst() && cursorPagos.getInt(0) == 0) {
            PagosWorker.allDataLoadedPagos = false;
        } else {
            PagosWorker.allDataLoadedPagos = true;
        }
        cursorPagos.close();

        PrestamosWorker.currentPagePrestamos = 0;
        PrestamosWorker.isTaskPrestamosCompleted = false;

        PagosWorker.currentPagePagos = 0;
        PagosWorker.isTaskPagosCompleted = false;

        PrestamosWorker.enqueueWork(DashboardActivity.this);
        checckBanderaPrestamos();

    }

    private void checckBanderaPrestamos() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (PrestamosWorker.isTaskPrestamosCompleted) {
                Log.d("PRESTAMOS", "Tarea PrestamosWorker PrestamosWorker.isTaskPrestamosCompleted");
                cargarPrestamosDesdeSQLite();
                PagosWorker.enqueueWork(DashboardActivity.this);
            } else {
                Log.d("PRESTAMOS", "Tarea PrestamosWorker aún no completadas. Reintentando en 500ms...");
                checckBanderaPrestamos(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }

    private void cargarPrestamosDesdeSQLite() {
        DatabaseHelper dbHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Log.d("PagosWorker", "Entro en cargarPrestamosDesdeSQLite()...................");

        // Definir columnas a obtener
        String[] columnas = {"id", "numero_tarjeton", "updated_at"};

        // Construcción de la consulta condicionalmente
        String selection = null;
        String[] selectionArgs = null;
        if (sesion.getString("nombre_perfil", "").equalsIgnoreCase("VOCERO") ||
                sesion.getString("nombre_perfil", "").equalsIgnoreCase("Administrador") ||
                sesion.getString("nombre_perfil", "").equalsIgnoreCase("ADMINISTRADOR")) {
            selection = "status != ?";
            selectionArgs = new String[]{"-1"};
        }

        try (Cursor cursor = db.query("prestamos", columnas, selection, selectionArgs, null, null, "updated_at DESC")) {
            if (cursor == null) {
                Log.e("PagosWorker", "El cursor es null, no se pudo realizar la consulta.");
                return;
            }

            PagosWorker.allPagos = new ArrayList<>(); // Reiniciar lista de pagos

            // Recorrer los resultados y agregar los IDs a allPagos
            while (cursor.moveToNext()) {
                String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                // Agregar ID de préstamo directamente a la lista de pagos validando que sea un número válido
                try {
                    PagosWorker.allPagos.add(Integer.valueOf(prestamoId));
                    Log.d("PagosWorker", "Lista de préstamos en allPagos SINCRONIZAR: " + PagosWorker.allPagos.toString());

                } catch (NumberFormatException e) {
                    Log.e("PagosWorker", "ID de préstamo no es un número válido: " + prestamoId);
                }
            }

            Log.d("PagosWorker", "Total de préstamos cargados: " + PagosWorker.allPagos.size());
            Log.d("PagosWorker", "Lista de préstamos en allPagos: " + PagosWorker.allPagos.toString());

        } catch (Exception e) {
            Log.e("PagosWorker", "Error al consultar la base de datos: " + e.getMessage());
        } finally {
            db.close(); // Cerrar la base de datos al final
        }

        // Solo actualizar la UI si la tarea se ha completado
        if (!PagosWorker.allPagos.isEmpty() && PrestamosWorker.isTaskPrestamosCompleted) {
            Log.d("PagosWorker", "Préstamos cargados correctamente y tarea completada.");
        } else {
            Log.d("PagosWorker", "No hay registros o la tarea no está completa.");
        }
    }


    public void sincronizarRutas() {

        vs = VolleyS.getInstance(this);
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "rutasActivas");

        } catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            //dialog.cancel();
                            JSONArray data = (JSONArray) response.get("data");
                            Log.d("SINCRONIZANDO", "RUTAS");
                            rutaController.truncate();

                            for (int i = 0; i < data.length(); i++) {

                                JSONObject obj = data.getJSONObject(i);
                                Gson gson = new Gson();
                                Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                rutaController.nueva(ruta);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                //dialog.cancel();
                ErrorChecker.checker(error, DashboardActivity.this);
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.clear();
    }

    public void sincronizarPoblaciones() {

        vs = VolleyS.getInstance(this);
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "index");

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            //dialog.cancel();
                            JSONArray data = (JSONArray) response.get("data");
                            Log.d("SINCRONIZANDO", "POBLACIONES");
                            poblacionController.truncate();

                            for (int i = 0; i < data.length(); i++) {
                                JSONObject obj = data.getJSONObject(i);
                                Gson gson = new Gson();
                                Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                poblacionController.nueva(poblacion);
                            }
                            /*finish();
                            overridePendingTransition(0, 0);
                            startActivity(getIntent());
                            overridePendingTransition(0, 0);*/
                            // Toast.makeText(DashboardActivity.this, "Poblaciones sincronizadas", Toast.LENGTH_SHORT).show();
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                //dialog.cancel();
                ErrorChecker.checker(error, DashboardActivity.this);

            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    public void sincronizarColocadoras() {
        vs = VolleyS.getInstance(this);
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "index");
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            //dialog.cancel();
                            JSONArray data = (JSONArray) response.get("data");
                            Log.d("SINCRONIZANDO", "COLOCADORAS");
                            colocadoraController.truncate();

                            for (int i = 0; i < data.length(); i++) {

                                JSONObject obj = data.getJSONObject(i);
                                Gson gson = new Gson();
                                Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                colocadoraController.nueva(colocadora);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                //dialog.cancel();
                ErrorChecker.checker(error, DashboardActivity.this);

            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    public void sincronizarReporteDiario() {
        DatabaseHelper dbHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        // Consultar registros con status = "1" o status = "2" de los gastos
        Cursor cursorGastos = db.rawQuery(
                "SELECT * FROM gastos WHERE status IN ('1', '2')",
                null
        );

        // Consultar registros con status = "1" o status = "2" del reporte
        Cursor cursor = db.rawQuery(
                "SELECT * FROM reporte_diario_rutas WHERE status IN ('1', '2')",
                null
        );

        // Procesar primero los gastos
        if (cursorGastos != null && cursorGastos.moveToFirst()) {
            do {
                String Gid = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("id"));
                String Gotros = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("otros"));
                String Ggasolina = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("gasolina"));
                String Ghotel = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("hotel"));
                String Galimentos = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("alimentos"));
                String Gcasetas = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("casetas"));
                String Gtotal = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("total"));

                String Gstatus = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("status"));

                // Crear JSON para enviar al servidor
                JSONObject dataGastos = new JSONObject();
                try {
                    dataGastos.put("id", Gid);
                    dataGastos.put("otros", Gotros);
                    dataGastos.put("gasolina", Ggasolina);
                    dataGastos.put("hotel", Ghotel);
                    dataGastos.put("alimentos", Galimentos);
                    dataGastos.put("casetas", Gcasetas);
                    dataGastos.put("total", Gtotal);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                // Manejar los casos de status = "1" o status = "2"
                if (Gstatus.equals("1")) {
                    Log.d("DEBUG", "SINCRONIZAR GASTOS de rutas CONDICION STATUS = 1 SIN Gastos INSERTAR......................");
                    try {
                        dataGastos.put("func", "createGastos");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    enviarSolicitudAlServidorGastos(Request.Method.POST, API.urlPagos, dataGastos, Gid, Gstatus);
                } else if (Gstatus.equals("2")) {
                    Log.d("DEBUG", "SINCRONIZAR GASTOS de rutas CONDICION STATUS = 2 EDITAR......................");
                    try {
                        dataGastos.put("func", "editGastos");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    enviarSolicitudAlServidorGastos(Request.Method.PUT, API.urlPagos, dataGastos, Gid, Gstatus);
                }

            } while (cursorGastos.moveToNext());
        }

        // Ahora procesar los reportes después de los gastos
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                String estimacion = cursor.getString(cursor.getColumnIndexOrThrow("estimacion"));
                String abonos_semana = cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana"));
                String recuperacion_semana = cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana"));
                String recuperacion_vencida = cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_vencida"));
                String anticipos = cursor.getString(cursor.getColumnIndexOrThrow("anticipos"));
                String total_1 = cursor.getString(cursor.getColumnIndexOrThrow("total_1"));
                String recuperacion_prestamos = cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos"));
                String colocacion = cursor.getString(cursor.getColumnIndexOrThrow("colocacion"));
                String prestamo_colocadora = cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora"));
                String comision = cursor.getString(cursor.getColumnIndexOrThrow("comision"));
                String bono_colocadora = cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora"));
                String total_2 = cursor.getString(cursor.getColumnIndexOrThrow("total_2"));
                String saldo = cursor.getString(cursor.getColumnIndexOrThrow("saldo"));
                String pendiente_recuperar = cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar"));
                String abonos_recuperar = cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar"));
                String comentario = cursor.getString(cursor.getColumnIndexOrThrow("comentario"));
                String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                String gastos_id = cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                String fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));

                String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));

                // Crear JSON para enviar al servidor
                JSONObject data = new JSONObject();
                try {
                    data.put("id", id);
                    data.put("poblacion_id", poblacion_id);
                    data.put("estimacion", estimacion);
                    data.put("abonos_semana", abonos_semana);
                    data.put("recuperacion_semana", recuperacion_semana);
                    data.put("recuperacion_vencida", recuperacion_vencida);
                    data.put("anticipos", anticipos);
                    data.put("total_1", total_1);
                    data.put("recuperacion_prestamos", recuperacion_prestamos);
                    data.put("colocacion", colocacion);
                    data.put("prestamo_colocadora", prestamo_colocadora);
                    data.put("comision", comision);
                    data.put("bono_colocadora", bono_colocadora);
                    data.put("total_2", total_2);
                    data.put("saldo", saldo);
                    data.put("pendiente_recuperar", pendiente_recuperar);
                    data.put("abonos_recuperar", abonos_recuperar);
                    data.put("comentario", comentario);
                    data.put("empleado_id", empleado_id);
                    data.put("fecha", fecha);
                    data.put("fecha_registro", fecha_registro);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                // Manejar los casos de status = "1" o status = "2"
                if (status.equals("0")) {
                    if (!gastos_id.isEmpty()) {
                        Log.d("DEBUG", "SINCRONIZAR Reporte diario de rutas CONDICION STATUS = 1 y Contiene ID de Gastos......................");
                        try {
                            data.put("func", "agregarRegistroReporteDiarioRutas");
                            data.put("gastos_id", gastos_id);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        enviarSolicitudAlServidorReporteDiarioRutas(Request.Method.POST, API.urlPagos, data, id, status);
                    } else {

                    }
                } else if (status.equals("1")) {
                    Log.d("DEBUG", "SINCRONIZAR Reporte diario de rutas CONDICION STATUS = 1 SIN Gastos......................");
                    try {
                        data.put("func", "createReporteDiarioRutas");
                        data.put("gastos_id", "");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    enviarSolicitudAlServidorReporteDiarioRutas(Request.Method.POST, API.urlPagos, data, id, status);
                } else if (status.equals("2")) {
                    Log.d("DEBUG", "SINCRONIZAR Reporte diario de rutas CONDICION STATUS = 2 EDITAR......................");
                    try {
                        data.put("func", "editReporteDiarioRutas");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    enviarSolicitudAlServidorReporteDiarioRutas(Request.Method.PUT, API.urlPagos, data, id, status);
                }

            } while (cursor.moveToNext());
        }

        if (cursorGastos != null) {
            cursorGastos.close();
        }
        if (cursor != null) {
            cursor.close();
        }

        db.close();
    }

    private void enviarSolicitudAlServidorReporteDiarioRutas(int method, String url, JSONObject data, String id, String status) {
        JsonObjectRequest request = new JsonObjectRequest(method, url, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String idServer = response.getJSONObject("data").getString("id");
                                String gastosId = response.getJSONObject("data").getString("gastos_id");
                                Log.d("DEBUG", "Status en el DATA ....................: " + status);
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de idServer'....................: " + idServer);
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de idServer'....................: " + gastosId);
                                // Actualizar el registro localmente
                                SQLiteDatabase writableDb = new DatabaseHelper(getApplicationContext()).getWritableDatabase();
                                ContentValues values = new ContentValues();
                                if (status.equals("1")) {
                                    if (gastosId != null && !gastosId.isEmpty()) {
                                        values.put("gastos_id", gastosId);
                                        values.put("status", "0");
                                        values.put("id", idServer);// Marcamos como sincronizado
                                        writableDb.update(
                                                "reporte_diario_rutas",
                                                values,
                                                "id = ?",
                                                new String[]{id}
                                        );
                                    }
                                } else {
                                    values.put("status", "0");
                                    writableDb.update(
                                            "reporte_diario_rutas",
                                            values,
                                            "id = ?",
                                            new String[]{id}
                                    );
                                }
                                writableDb.close();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                // Manejo de errores
                ErrorChecker.checker(error, DashboardActivity.this);
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    private void enviarSolicitudAlServidorGastos(int method, String url, JSONObject data, String id, String gstatus) {
        JsonObjectRequest request = new JsonObjectRequest(method, url, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String idServer = response.getJSONObject("data").getString("id");
                                Log.d("DEBUG", "Status en el DATA ....................: " + gstatus);
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de idServer'....................: " + idServer);
                                // Actualizar el registro localmente
                                SQLiteDatabase writableDb = new DatabaseHelper(getApplicationContext()).getWritableDatabase();
                                ContentValues values = new ContentValues();
                                if (gstatus.equals("1")) {
                                    values.put("status", "0");
                                    values.put("id", idServer);// Marcamos como sincronizado
                                    writableDb.update(
                                            "gastos",
                                            values,
                                            "id = ?",
                                            new String[]{id}
                                    );
                                } else {
                                    values.put("status", "0");
                                    writableDb.update(
                                            "gastos",
                                            values,
                                            "id = ?",
                                            new String[]{id}
                                    );
                                }
                                writableDb.close();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                // Manejo de errores
                ErrorChecker.checker(error, DashboardActivity.this);
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    public void dbSync() {
        syncServerApp(new RMDFragment.SyncCallback() {
            @Override
            public void onSuccess() { }
        });

        syncAppServer(new RMDFragment.SyncCallback() {
            @Override
            public void onSuccess() { }
        });
        Toast.makeText(DashboardActivity.this, "RMDs insertados", Toast.LENGTH_SHORT).show();
    }

    public void syncServerApp(RMDFragment.SyncCallback callback) {
        RMDController rmdController = new RMDController(DashboardActivity.this, null);

        rmdController.getCountRMDsServidor(new RMDController.GetCountRMDsServidorCallback() {
            @Override
            public void onSuccess(int n) {
                int c = rmdController.getRMDSCount();
                if (c == n) {
                    callback.onSuccess();
                } else {
                    rmdController.getRMDSinSincronizar(new RMDController.GetRMDsSinSincronizarCallback() {
                        @Override
                        public void onSuccess(ArrayList<RMD> rmds) {
                            if (rmds != null && !rmds.isEmpty()) {
                                for (RMD rmd : rmds) {
                                    rmdController.intertarRMDServidor(rmd, new RMDController.SincronizarDelServidorCallback() {
                                        @Override
                                        public void onSuccess() { }

                                        @Override public void onError(String error) { }
                                    });
                                }
                            }
                        }

                        @Override public void onError(String error) { }
                    });
                }

            }

            @Override
            public void onError(String error) {
                Log.d("ERROR", "onError: " + error);
            }
        });
    }

    public void syncAppServer(RMDFragment.SyncCallback callback) {
        RMDController rmdController = new RMDController(DashboardActivity.this, null);

        ArrayList<RMD> rmds = rmdController.getRMDsDesincronizados();

        if (rmds != null && !rmds.isEmpty()) {
            sincronizar(rmds);
            callback.onSuccess();
        } else {
            callback.onSuccess();
        }
    }

    public void sincronizar(ArrayList<RMD> rmds) {
        RMDController rmdController = new RMDController(DashboardActivity.this, null);

        for (RMD rmd : rmds) {
            rmdController.subirRMDsDesincronizadosServidor(rmd, new RMDController.SubirRMDsDesincronizadosServidorCallback() {
                @Override
                public void onSuccess() { }

                @Override
                public void onError(String error) {

                }
            });
        }
    }

    public void syncFolios() {
        DatabaseHelper dbHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        ArrayList<Folio> unsyncedFolios = new ArrayList<>();

        unsyncedFolios = getUnsyncedFolios();

        if (!unsyncedFolios.isEmpty()) {
            for (Folio folio : unsyncedFolios) {
                JSONObject data = new JSONObject();
                try {
                    data.put("func", "storeFolio");
                    data.put("folio", folio.getId());
                    data.put("fecha", folio.getFecha());
                    data.put("hora", folio.getHora());
                    data.put("cliente_id", folio.getCliente_id());
                    data.put("ruta_id", folio.getRuta_id());
                    data.put("poblacion_id", folio.getPoblacion_id());
                    data.put("monto", folio.getMonto());
                    data.put("monto_letra", folio.getMonto_letra());
                    data.put("concepto", folio.getConcepto());
                    data.put("firma_usuario", folio.getFirma_usuario());
                    data.put("firma_cliente", folio.getFirma_cliente());
                } catch (JSONException e) { }

                Log.d("data", data.toString());

                vs = VolleyS.getInstance(this);
                requestQueue = vs.getRequestQueue();

                JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                        new Response.Listener<JSONObject>() {
                            @Override
                            public void onResponse(JSONObject response) {
                                Log.d("sync repsonse", "onResponse: " + response);
                                String query = "UPDATE folios SET sync = 1 WHERE id = ?";
                                SQLiteDatabase db = dbHelper.getWritableDatabase();
                                db.execSQL(query, new String[]{folio.getId()});
                                db.close();
                            }

                        },
                        new Response.ErrorListener() {
                            @Override
                            public void onErrorResponse(VolleyError error) {
                                Log.d("sync error dashboard", "onErrorResponse: " + error);
                            }
                        });

                request.setRetryPolicy(new DefaultRetryPolicy(
                        5000,
                        DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

                request.setShouldCache(false);

                VolleyS vs = VolleyS.getInstance(context);
                RequestQueue requestQueue = vs.getRequestQueue();

                requestQueue.add(request);
            }
        }

        JSONObject data = new JSONObject();
        try {
            data.put("func", "indexFolio");
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                JSONArray dataArray = response.getJSONArray("data");

                                for (int i = 0; i < dataArray.length(); i++) {
                                    JSONObject folioObject = dataArray.getJSONObject(i);
                                    Folio newFolio = new Folio(
                                            folioObject.getString("id"),
                                            folioObject.getString("fecha"),
                                            folioObject.getString("hora"),
                                            folioObject.getString("cliente_id"),
                                            folioObject.getString("ruta_id"),
                                            folioObject.getString("poblacion_id"),
                                            folioObject.getString("monto"),
                                            folioObject.getString("monto_letra"),
                                            folioObject.getString("concepto"),
                                            folioObject.getString("firma_usuario"),
                                            folioObject.getString("firma_cliente")
                                    );

                                    Log.d("folioDescargado", newFolio.toString());

                                    Folio existingFolio = getFolioFromDbById(newFolio.getId());

                                    if (existingFolio == null) {
                                        storeSync(newFolio);
                                    } else {
                                        if (!newFolio.equals(existingFolio)) {
                                            updateFolioInDb(newFolio);
                                            Log.d("folioActualizado", newFolio.toString());
                                        } else {
                                            Log.d("folioSinCambios", newFolio.getId());
                                        }
                                    }
                                }
                            } else {
                                Toast.makeText(context, "Error del servidor: " + response.getString("message"), Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            Toast.makeText(context, "Error al parsear respuesta JSON.", Toast.LENGTH_SHORT).show();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        Toast.makeText(context, "Error de red: " + error.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                });

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        request.setShouldCache(false);

        VolleyS.getInstance(context).getRequestQueue().add(request);
    }

    private void updateFolioInDb(Folio newFolio) {
        DatabaseHelper databaseHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("fecha", newFolio.getFecha());
        cv.put("hora", newFolio.getHora());
        cv.put("cliente_id", newFolio.getCliente_id());
        cv.put("ruta_id", newFolio.getRuta_id());
        cv.put("poblacion_id", newFolio.getPoblacion_id());
        cv.put("monto", newFolio.getMonto());
        cv.put("monto_letra", newFolio.getMonto_letra());
        cv.put("concepto", newFolio.getConcepto());
        cv.put("firma_usuario", newFolio.getFirma_usuario());
        cv.put("firma_cliente", newFolio.getFirma_cliente());
        cv.put("sync", 1);
        db.update("folios", cv, "id = ?", new String[]{newFolio.getId()});
        db.close();
    }

    public boolean folioExists(String folioId) {
        DatabaseHelper databaseHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT id FROM folios WHERE id = ?", new String[]{folioId});
        boolean exists = cursor.moveToFirst();
        cursor.close();
        db.close();
        return exists;
    }

    public double storeSync(Folio folio) {
        DatabaseHelper databaseHelper = new DatabaseHelper(DashboardActivity.this);

        if (folioExists(folio.getId())) {
            return -1;
        }

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();

        cv.put("id", folio.getId());
        cv.put("fecha", folio.getFecha());
        cv.put("hora", folio.getHora());
        cv.put("cliente_id", folio.getCliente_id());
        cv.put("ruta_id", folio.getRuta_id());
        cv.put("poblacion_id", folio.getPoblacion_id());
        cv.put("monto", folio.getMonto());
        cv.put("monto_letra", folio.getMonto_letra());
        cv.put("concepto", folio.getConcepto());
        cv.put("firma_usuario", folio.getFirma_usuario());
        cv.put("firma_cliente", folio.getFirma_cliente());
        cv.put("sync", 1);

        String createUsuariosFoliosTable = "CREATE TABLE IF NOT EXISTS usuarios_folios (" +
                "usuario_id INTEGER," +
                "folio_id INTEGER);";

        db.execSQL(createUsuariosFoliosTable);

        String query = "DELETE FROM usuarios_folios WHERE folio_id = ?";
        db.execSQL(query, new String[]{folio.getId()});

        Log.d(TAG, "storeSync: " + folio.getId());

        return db.insert("folios", null, cv);
    }

    private Folio getFolioFromDbById(String id) {
        DatabaseHelper databaseHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        try {
            String query = "SELECT * FROM folios WHERE id = ?";
            Cursor cursor = db.rawQuery(query, new String[]{id});
            Folio folio = null;

            if (cursor.moveToFirst()) {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);

                folio = new Folio(
                        nFolio,
                        fecha,
                        hora,
                        cliente_id,
                        ruta_id,
                        poblacion_id,
                        monto,
                        monto_letra,
                        concepto,
                        firma_usuario,
                        firma_cliente
                );
                cursor.close();
                db.close();
                return folio;
            }
            cursor.close();
            db.close();
            return folio;
        } catch (Exception e ) {
            String drop = "DROP TABLE folios";
            db.execSQL(drop);

            String createTableQuery = "CREATE TABLE IF NOT EXISTS folios (" +
                    "id INTEGER PRIMARY KEY," +
                    "fecha VARCHAR(10)," +
                    "hora TIME," +
                    "cliente_id VARCHAR(100)," +
                    "ruta_id INTEGER," +
                    "poblacion_id INTEGER," +
                    "monto VARCHAR(50)," +
                    "monto_letra VARCHAR(200)," +
                    "concepto VARCHAR(1000)," +
                    "firma_usuario VARCHAR(200000)," +
                    "firma_cliente VARCHAR(200000)," +
                    "sync VARCHAR(1)" +
                    ");";

            db.execSQL(createTableQuery);
            syncFolios();
        }
        return null;
    }

    public ArrayList<Folio> getUnsyncedFolios() {
        DatabaseHelper dbHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<>();
        try {
            String query = "SELECT * FROM folios WHERE sync = 0";
            Cursor cursor = db.rawQuery(query, new String[]{});

            if (cursor.moveToFirst()) {
                do {
                    String nFolio = cursor.getString(0);
                    String fecha = cursor.getString(1);
                    String hora = cursor.getString(2);
                    String cliente_id = cursor.getString(3);
                    String ruta_id = cursor.getString(4);
                    String poblacion_id = cursor.getString(5);
                    String monto = cursor.getString(6);
                    String monto_letra = cursor.getString(7);
                    String concepto = cursor.getString(8);
                    String firma_usuario = cursor.getString(9);
                    String firma_cliente = cursor.getString(10);

                    Folio folio = new Folio(
                            nFolio,
                            fecha,
                            hora,
                            cliente_id,
                            ruta_id,
                            poblacion_id,
                            monto,
                            monto_letra,
                            concepto,
                            firma_usuario,
                            firma_cliente
                    );
                    folios.add(folio);
                } while (cursor.moveToNext());

                cursor.close();
                db.close();
            }
            return folios;
        } catch (Exception e) {
            String drop = "DROP TABLE folios";
            db.execSQL(drop);

            String createTableQuery = "CREATE TABLE IF NOT EXISTS folios (" +
                    "id INTEGER PRIMARY KEY," +
                    "fecha VARCHAR(10)," +
                    "hora TIME," +
                    "cliente_id VARCHAR(100)," +
                    "ruta_id INTEGER," +
                    "poblacion_id INTEGER," +
                    "monto VARCHAR(50)," +
                    "monto_letra VARCHAR(200)," +
                    "concepto VARCHAR(1000)," +
                    "firma_usuario VARCHAR(200000)," +
                    "firma_cliente VARCHAR(200000)," +
                    "sync VARCHAR(1)" +
                    ");";

            db.execSQL(createTableQuery);
            syncFolios();
        }
        return folios;
    }

    public void sincronizarReporteCreditos(){
        DatabaseHelper dbHelper = new DatabaseHelper(DashboardActivity.this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        // Consultar registros con status = "1" o status = "2" del reporte
        Cursor cursor = db.rawQuery(
                "SELECT * FROM reporte_creditos WHERE status IN ('1', '2')",
                null
        );

        // Procesar primero los gastos
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                String observaciones = cursor.getString(cursor.getColumnIndexOrThrow("observaciones"));
                String creditos_otorgados = cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados"));
                String total_prestamos = cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos"));
                String prestamos_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos"));
                String monto_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos"));
                String prestamos_renovados = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados"));
                String monto_renovados = cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados"));
                String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                String fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));

                String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));

                // Crear JSON para enviar al servidor
                JSONObject data = new JSONObject();
                try {
                    data.put("id", id);
                    data.put("poblacion_id", poblacion_id);
                    data.put("observaciones", observaciones);
                    data.put("creditos_otorgados", creditos_otorgados);
                    data.put("total_prestamos", total_prestamos);
                    data.put("prestamos_nuevos", prestamos_nuevos);
                    data.put("monto_nuevos", monto_nuevos);
                    data.put("prestamos_renovados", prestamos_renovados);
                    data.put("monto_renovados", monto_renovados);
                    data.put("empleado_id", empleado_id);
                    data.put("fecha", fecha);
                    data.put("fecha_registro", fecha_registro);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                // Manejar los casos de status = "1" o status = "2"
                if (status.equals("1")) {
                    Log.d("DEBUG", "SINCRONIZAR GASTOS de rutas CONDICION STATUS = 1 SIN Gastos INSERTAR......................");
                    try {
                        data.put("func", "createReporteCreditos");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    enviarSolicitudAlServidorCreditos(Request.Method.POST, API.urlPagos, data, id, status);
                } else if (status.equals("2")) {
                    Log.d("DEBUG", "SINCRONIZAR GASTOS de rutas CONDICION STATUS = 2 EDITAR......................");
                    try {
                        data.put("func", "editReporteCreditos");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    enviarSolicitudAlServidorCreditos(Request.Method.PUT, API.urlPagos, data, id, status);
                }

            } while (cursor.moveToNext());
        }

        // Ahora procesar los reportes después de los gastos
        if (cursor != null) {
            cursor.close();
        }

        db.close();
    }
    private void enviarSolicitudAlServidorCreditos(int method, String url, JSONObject data, String id, String status) {
        JsonObjectRequest request = new JsonObjectRequest(method, url, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String idServer = response.getJSONObject("data").getString("id");
                                Log.d("DEBUG", "Status en el DATA ....................: " + status);
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de idServer'....................: " + idServer);
                                // Actualizar el registro localmente
                                SQLiteDatabase writableDb = new DatabaseHelper(getApplicationContext()).getWritableDatabase();
                                ContentValues values = new ContentValues();
                                if (status.equals("1"))
                                {
                                    values.put("status", "0");
                                    values.put("id", idServer);// Marcamos como sincronizado
                                    writableDb.update(
                                            "reporte_creditos",
                                            values,
                                            "id = ?",
                                            new String[]{id}
                                    );
                                }
                                else
                                {
                                    values.put("status", "0");
                                    writableDb.update(
                                            "reporte_creditos",
                                            values,
                                            "id = ?",
                                            new String[]{id}
                                    );
                                }
                                writableDb.close();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                // Manejo de errores
                ErrorChecker.checker(error, DashboardActivity.this);
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }
    public static class ConfirmLogoutDialogFragment extends DialogFragment {
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new MaterialAlertDialogBuilder(requireContext())
                    .setTitle("Aviso")
                    .setMessage("¿Desea cerrar sesión?")
                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            // Cierra la aplicación si se confirma
                            getActivity().finish();
                        }
                    })
                    .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            // Simplemente cerrar el diálogo si se cancela
                            dialog.dismiss();
                        }
                    })
                    .create();
        }
    }



    // Para mostrar el DialogFragment
    @Override
    public void onBackPressed() {
        super.onBackPressed();
        DrawerLayout drawer = findViewById(R.id.drawer_layout);
        if (drawer.isDrawerOpen(GravityCompat.START)) {
            drawer.closeDrawer(GravityCompat.START);
        } else {
            if (CurrentFragment.fragment.equals("ClientesEditarFragment")
                    || CurrentFragment.fragment.equals("ClientesCrearFragment")
                    || CurrentFragment.fragment.equals("PrestamosCrearFragment")) {
                navController.navigate(R.id.nav_clientes);
            } else if (CurrentFragment.fragment.equals("PagosFragment")
                    || CurrentFragment.fragment.equals("PagosPagarFragment")) {
                navController.navigate(R.id.nav_prestamos);
            } else {
                // Mostrar el diálogo de confirmación y prevenir el cierre inmediato de la actividad
                new ConfirmLogoutDialogFragment().show(getSupportFragmentManager(), "confirmLogout");
            }
        }
    }

    public interface ConexionCallback {
        void onSuccess();

    }

    public void conectarImpresora(ConexionCallback callback) {
        BluetoothUtils.context = getApplicationContext();

        BluetoothUtils.listPairedDevices(sesion.getString("impresora", "SP-T12 Printer"));
        IntentFilter filter = new IntentFilter();
        filter.addAction(BluetoothDevice.ACTION_ACL_CONNECTED);
        filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECT_REQUESTED);
        filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECTED);
        registerReceiver(BluetoothUtils.BTReceiver, filter);
        BluetoothUtils.broadcastReceiver();
        BluetoothUtils.initThread();

        callback.onSuccess();
    }

}